unit FileBVH;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OpenGL, MyGLInit, MotionBlending, Math, CgTypes;

type
  TPJoint = ^TJoint;

  TFrame = class
  private
  public
    data:array of {single}real;
    constructor Create();overload;
    constructor Create(frame1,frame2:TFrame;w:real);overload;
    destructor Destroy();override;
  end;

  TAnimation = class
  private
  public
    name:string;
    PCD:array of array of real;  //array of point cloud data for each frame
    frames:array of TFrame;
    constructor Create(n:string);
    destructor Destroy();override;
  end;

  TJoint = class
  private
    is_root, is_end:boolean;
    name:string;
    p_parent:TPJoint;
    descendants:array of TPJoint;
    offset:array[0..2] of real;
    rotation:array[0..2] of real;
  public
    procedure Add_descendant(var descendant:TPJoint);
    constructor Create(joint:string); overload;
    constructor Create(joint: string;p_ancestor:TPJoint);overload;
    constructor Create(joint:string;p_ancestor:TPJoint;par:string); overload;
    destructor Destroy();override;
  end;

  TSkeleton = class
  private
    x_pos, y_pos, z_pos, y0:real;
    root:TPJoint;
    draw_counter, PCD_counter:word;
    separator:char;
    zyx:boolean;
  public
    PC_already, pointcloud:boolean; //whether pointclouds were extracted already
    z_viewport:single;
    joints_count:byte;
    pom:array of real;
    frame_time:real;
    frames_count:word;
    actual_frame:smallint;
    animation:TAnimation;
    constructor Create(filename:string);
    procedure display(f:smallint;rr,gg,bb:byte;play:boolean);
    procedure LI_display(f:single;rr,gg,bb:byte);
    procedure Save(name:string);
    destructor Destroy();override;
  end;

implementation

{ TJoint }

constructor TJoint.Create(joint: string);
begin
  name:=joint;
  is_root:=true;
  p_parent:=nil;
  Setlength(descendants,0);
  is_end:=false;
end;

procedure TJoint.Add_descendant(var descendant:TPJoint);
begin
  Setlength(descendants, length(descendants)+1);
  descendants[high(descendants)]:=descendant;
end;

constructor TJoint.Create(joint: string;p_ancestor:TPJoint);
begin
  name:=joint;
  is_root:=false;
  p_parent:=p_ancestor;
  Setlength(descendants,0);
  is_end:=false;
end;

destructor TJoint.Destroy;
var i:byte;
begin
  inherited;
// free array of descendants
  for i:=0 to high(descendants) do
    descendants[i]:=nil;
end;

constructor TJoint.Create(joint: string; p_ancestor: TPJoint; par: string);
begin
  if par='end' then
  begin
    name:=joint;
    is_root:=false;
    p_parent:=p_ancestor;
    Setlength(descendants,0);
    is_end:=true;
  end
  else
    raise Exception.Create('"end" expected as parameter');
end;

{ TSkeleton }

constructor TSkeleton.Create(filename: string);
var
  f: TFileStream;
  sl:TStringList;
  rootname,word:string;
  row,i,j:integer;
  g_joint:TJoint;
  format_string:TFormatSettings;
  ch:char;

  procedure bvh_parse(j:TJoint; bvh_data:TStringList;var joints_count:byte);
  var pom, value:string;
      desc: TJoint;
      p_j, p_desc: TPJoint;
  begin
      if trim(bvh_data[row]) <> '{' then
        raise Exception.Create('"{" expected but not found');
      inc(row);
//OFFSET
      if Copy(trim(bvh_data[row]),1,6) <> 'OFFSET' then
        raise Exception.Create('"OFFSET" expected but not found');

      // pom:= data OFFSETu
      pom:=Copy(trim(bvh_data[row]),8,Length(trim(bvh_data[row]))-7);
      // value:= prva hodnota OFFSETu
      value:=Copy(pom,1,Pos(separator,pom)-1);
      j.offset[0]:= StrToFloat(value,format_string);
      // pom:= uz len zvysne dve hodnoty
      delete(pom,1,Pos(separator,pom));
      // value:= druha hodnota OFFSETu
      value:=Copy(pom,1,Pos(separator,pom)-1);
      j.offset[1]:= StrToFloat(value,format_string);
      // pom:= tretia hodnota OFFSETu
      delete(pom,1,Pos(separator,pom));
      j.offset[2]:= StrToFloat(pom,format_string);
      inc(row);
//CHANNELS
      if Copy(trim(bvh_data[row]),1,8) <> 'CHANNELS' then
         raise Exception.Create('"CHANNELS" expected but not found');

      // pom:= data CHANNELSu
      pom:=Copy(trim(bvh_data[row]),10,Length(trim(bvh_data[row]))-9);
      // value:= pocet CHANNELS
      value:=Copy(pom,1,1);
      Delete(pom,1,2);
      if StrToInt(value) = 6 then
      begin
        if (pom <> 'Xposition Yposition Zposition Zrotation Xrotation Yrotation') and (pom <> 'Xposition Yposition Zposition Zrotation Yrotation Xrotation') then
          raise Exception.Create('Wrong root channels');
        if pom = 'Xposition Yposition Zposition Zrotation Yrotation Xrotation' then
          zyx:=true;
      end
      else
        if StrToInt(value) = 3 then
        begin
          if (pom <> 'Zrotation Xrotation Yrotation') and (pom <> 'Zrotation Yrotation Xrotation') then
            raise Exception.Create('Wrong '+j.name+' channels')
        end
      else raise Exception.Create('Wrong number of channels');

      inc(row);
      pom:= Copy(trim(bvh_data[row]),1,8);
      if (Copy(pom,1,5) <> 'JOINT') and (pom <>'End Site') then
        raise Exception.Create('"JOINT" or "End Site" expected but not found');
//JOINT
      if Copy(pom,1,5) = 'JOINT' then
      begin
        // pom:= nazov JOINTu
        pom:=Copy(trim(bvh_data[row]),7,Length(trim(bvh_data[row]))-6);
        inc(row);
        //recursion
        new(p_j);
        p_j^:=j;
        inc(joints_count);
        desc:=TJoint.Create(pom,p_j);
        new(p_desc);
        p_desc^:=desc;
        j.Add_descendant(p_desc);
        bvh_parse(desc,bvh_data,joints_count);

        repeat
        begin
          inc(row);
          pom:=Copy(trim(bvh_data[row]),1,5);
          if pom = 'JOINT' then
          begin
            value:=trim(bvh_data[row]);
            Delete(value,1,6);
            inc(row);
            inc(joints_count);
            desc:=TJoint.Create(value,p_j);
            new(p_desc);
            p_desc^:=desc;
            j.Add_descendant(p_desc);
            bvh_parse(desc,bvh_data,joints_count);
          end;
        end;
        until pom <> 'JOINT';

        if pom <> 'JOINT' then dec(row);
      end;
//END SITE
      if pom = 'End Site' then
      begin
        inc(row);
        if trim(bvh_data[row]) <> '{' then
          raise Exception.Create('"{" expected but not found');
        inc(row);
        if Copy(trim(bvh_data[row]),1,6) <> 'OFFSET' then
          raise Exception.Create('"OFFSET" expected but not found');

        new(p_j);
        p_j^:=j;
        desc:=TJoint.Create(J.name+'End',p_j,'end');
        new(p_desc);
        p_desc^:=desc;
        j.Add_descendant(p_desc);

        // pom:= data OFFSETu
        pom:=Copy(trim(bvh_data[row]),8,Length(trim(bvh_data[row]))-7);
        // value:= prva hodnota OFFSETu
        value:=Copy(pom,1,Pos(separator,pom)-1);
        desc.offset[0]:=StrToFloat(value,format_string);
        // pom:= uz len zvysne dve hodnoty
        delete(pom,1,Pos(separator,pom));
        // value:= druha hodnota OFFSETu
        value:=Copy(pom,1,Pos(separator,pom)-1);
        desc.offset[1]:=StrToFloat(value,format_string);
        // pom:= tretia hodnota OFFSETu
        delete(pom,1,Pos(separator,pom));
        desc.offset[2]:=StrToFloat(pom,format_string);

        inc(row);
        if trim(bvh_data[row]) <> '}' then
          raise Exception.Create('"}" expected but not found');
      end;
      inc(row);
      if trim(bvh_data[row]) <> '}' then
        raise Exception.Create('"}" expected but not found');
  end;

  procedure frame_parse(var frame:TFrame;raw_data:string);
  var slovo:string;
      m,n:integer;
  begin
    n:=3+joints_count*3;
    for m:=0 to n-2 do
    begin
      slovo:=Copy(raw_data,1,Pos(separator,raw_data)-1);
      setlength(frame.data,length(frame.data)+1);
      frame.data[m]:=StrToFloat(trim(slovo),format_string);
      delete(raw_data,1,Pos(separator,raw_data));
    end;
    slovo:=trim(raw_data);
    setlength(frame.data,length(frame.data)+1);
    frame.data[high(frame.data)]:=StrToFloat(slovo,format_string);
  end;

  procedure vypis(var l_joint:TJoint);
  var i,j:integer;
  begin
    Showmessage(l_joint.name+' '+inttostr(length(l_joint.descendants))+' potomkov');
    Showmessage('OFFSET '+FloatToStr(l_joint.offset[0])+' '+FloatToStr(l_joint.offset[1])+' '+FloatToStr(l_joint.offset[2]));
    j:=length(l_joint.descendants);
    if j > 0 then
      for i:=0 to j-1 do
        vypis(l_joint.descendants[i]^);
  end;

begin
  zyx:=false;
  x_pos:=0;
  y_pos:=0;
  z_pos:=0;
  draw_counter:=3;
  PCD_counter:=3;
  frames_count:=0;
  joints_count:=0;
  frame_time:=0;

  PC_already:=false;
  setlength(pom,0);

  sl:=TStringList.Create;
  row:=2;
//nastavenie formatovania retazcov
  GetLocaleFormatSettings(0,format_string);
  format_string.DecimalSeparator:='.';

  SetCurrentDir(ExtractFilePath(Application.ExeName)+'\stream');
  f:=TFileStream.Create(filename,fmOpenRead);
  try
    sl.LoadFromStream(f);
    if sl[0]<>'HIERARCHY' then
         raise Exception.Create('BVH HIERARCHY required');
    if Copy(sl[1],1,4)<>'ROOT' then
         raise Exception.Create('ROOT not found');
    rootname:=Copy(sl[1],Pos(' ',sl[1])+1,Length(sl[1])-5);
//this determines the separator between numeric data in bvh-file (tab/space)
    separator:=sl[3][Pos('T',sl[3])+1];

    g_joint:=TJoint.Create(rootname);
    joints_count:=1;
//initialization of skeleton root
    new(root);
    root^:=g_joint;
    bvh_parse(g_joint,sl,joints_count);
    Showmessage('Joints = '+IntToStr(joints_count));

    inc(row);

    if Copy(trim(sl[row]),1,6) <> 'MOTION' then
      raise Exception.Create('"MOTION" expected but not found');
    inc(row);
    if Copy(trim(sl[row]),1,7) <> 'Frames:' then
      raise Exception.Create('"Frames:" expected but not found');
    word:=trim(Copy(sl[row],8,Length(sl[row])-7));
    frames_count:=StrToInt(word);

    inc(row);
    if Copy(trim(sl[row]),1,11) <> 'Frame Time:' then
      raise Exception.Create('"Frame Time:" expected but not found');
    word:=trim(Copy(sl[row],12,Length(sl[row])-11));
    frame_time:=StrToFloat(word, format_string);

// feature that finds out which separator parses frame data
    inc(row);
    i:=0;
    ch:=#13;
    while (ch<>#9) and (ch<>#32) do
    begin
      inc(i);
      ch:=sl[row][i];
    end;
    separator:=ch;
    dec(row);

//animation data
    animation:=TAnimation.Create(filename);

    for i:=0 to frames_count-1 do
    begin
      inc(row);
      setlength(animation.frames,length(animation.frames)+1);
      animation.frames[high(animation.frames)]:=TFrame.Create;
//read frame data from bvh file
      frame_parse(animation.frames[high(animation.frames)],sl[row]);
    end;
//set the first frame in array as actual
    actual_frame:=0;

//initialize PCD
    Setlength(animation.PCD,length(animation.frames));
{    for j:=0 to high(animation.PCD) do
      Setlength(animation.PCD[j],joints_count*3);
}
      Setlength(animation.PCD[0],joints_count*3);

//kontrola struktury s Joint-ami
  finally
    sl.Free;
  end;
  f.Free;
end;

destructor TSkeleton.Destroy;
begin
  inherited;
  animation.Destroy;
end;

procedure TSkeleton.display(f:smallint;rr,gg,bb:byte;play:boolean);
var end_joint:boolean;
    pom_counter,i:smallint;

  procedure kresli(var l_joint:TJoint;a,b,c,d,e,f: real);
  var i,j:integer;
      MV:TCGMatrix;
  begin
     j:=length(l_joint.descendants);
     material_color(rr,gg,bb,1);

     glMatrixMode(GL_MODELVIEW);
     glPushMatrix();

     glTranslatef(a,b,c);

     if (pom_counter<length(pom)) and (not l_joint.is_root) and (not end_joint) then    //point clouds are not created yet
     begin
       glGetFloatv(GL_MODELVIEW_MATRIX,@MV);     //we get current MV matrix to get absolute coordinates
       pom[pom_counter]:=MV[3][0];       //last row in the matrix means absolute translation vector
       inc(pom_counter);
       pom[pom_counter]:=MV[3][1];
       inc(pom_counter);
       pom[pom_counter]:=MV[3][2]-z_viewport;
       inc(pom_counter);
       if l_joint.is_end then end_joint:=true;

       if pom_counter=length(pom) then pointcloud:=true;
     end;

     if (not l_joint.is_end) and end_joint then //we get rid of the unuseful joints ending with "End"
       end_joint:=false;

     gluSphere(gluNewQuadric, 1, 5, 5);
     glRotatef(d,0.0,0.0,1.0);
     glRotatef(e,1.0,0.0,0.0);
     glRotatef(f,0.0,1.0,0.0);
     glTranslatef(-a,-b,-c);

     if j = 0 then
       material_color(255,255,0,1);

     glPointSize(3);
     glBegin(GL_LINES);
       glVertex3f(a,b,c);
       glVertex3f(a+l_joint.offset[0],b+l_joint.offset[1],c+l_joint.offset[2]);
     glEnd();

     d:=l_joint.rotation[0];
     e:=l_joint.rotation[1];
     f:=l_joint.rotation[2];

     for i:=0 to j-1 do
       kresli(l_joint.descendants[i]^,a+l_joint.offset[0],b+l_joint.offset[1],c+l_joint.offset[2],d,e,f);

     glPopMatrix();
  end;

  procedure load_rotations(var p_joint:TPJoint);
  var i,j:integer;
  begin
    j:=length(p_joint^.descendants);
    if j > 0 then
    begin
      if (not zyx) then
      begin
        p_joint^.rotation[0]:=animation.frames[actual_frame].data[draw_counter];
        inc(draw_counter);
        p_joint^.rotation[1]:=animation.frames[actual_frame].data[draw_counter];
        inc(draw_counter);
        p_joint^.rotation[2]:=animation.frames[actual_frame].data[draw_counter];
        inc(draw_counter);

        for i:=0 to j-1 do
          load_rotations(p_joint^.descendants[i]);
      end
      else
      begin
        p_joint^.rotation[0]:=animation.frames[actual_frame].data[draw_counter];
        inc(draw_counter);
        p_joint^.rotation[2]:=animation.frames[actual_frame].data[draw_counter];
        inc(draw_counter);
        p_joint^.rotation[1]:=animation.frames[actual_frame].data[draw_counter];
        inc(draw_counter);

        for i:=0 to j-1 do
          load_rotations(p_joint^.descendants[i]);
      end;
    end;
  end;

begin
  pointcloud:=false;
  end_joint:=false;

  x_pos:=animation.frames[f].data[0];
  y_pos:=animation.frames[f].data[1];
  z_pos:=animation.frames[f].data[2];

  if f=0 then y0:=y_pos; //save the y value of the 1st frame

  draw_counter:=3;
  load_rotations(root);
//three nulls for initial rotations ensure that the offset
//executes always before rotations at individual joint
  setlength(pom, joints_count*3);
  pom_counter:=0;
  kresli(root^,x_pos,y_pos-y0,z_pos,0,0,0);

  PC_already:=true;

if not play then
begin
//we compute the point cloud data
  for i:=0 to (high(pom)-2) div 3 do
  begin
    animation.PCD[actual_frame][i*3+0]:=pom[i*3];  //absolute root positions
    animation.PCD[actual_frame][i*3+1]:=pom[i*3+1];
    animation.PCD[actual_frame][i*3+2]:=pom[i*3+2];
  end;
end;
end;
//Linear Interpolation of frames
procedure TSkeleton.LI_display(f: single;rr,gg,bb:byte);
var
  alfa:single;      //parameter of linear interpolation
  whole:smallint;   //which frames we blend
  in_between:TFrame; //resulting in-between frame
  i:integer;

  procedure kresli(var l_joint:TJoint;a,b,c,d,e,f: real);
  var i,j:integer;
  begin
  j:=length(l_joint.descendants);

     material_color(0,0,255,1);
     if l_joint.name = 'Hips' then
       material_color(255,0,0,1);

     glMatrixMode(GL_MODELVIEW);
     glPushMatrix();
       glTranslatef(a,b,c);
       gluSphere(gluNewQuadric, 1, 5, 5);
       glRotatef(d,0.0,0.0,1.0);
       glRotatef(e,1.0,0.0,0.0);
       glRotatef(f,0.0,1.0,0.0);
       glTranslatef(-a,-b,-c);
     if j = 0 then
       material_color(255,255,0,1);

     glPointSize(3);
     glBegin(GL_LINES);
       glVertex3f(a,b,c);
       glVertex3f(a+l_joint.offset[0],b+l_joint.offset[1],c+l_joint.offset[2]);
     glEnd();

     d:=l_joint.rotation[0];
     e:=l_joint.rotation[1];
     f:=l_joint.rotation[2];

      for i:=0 to j-1 do
        kresli(l_joint.descendants[i]^,a+l_joint.offset[0],b+l_joint.offset[1],c+l_joint.offset[2],d,e,f);

    glPopMatrix();
  end;

  procedure load_rotations(var p_joint:TPJoint);
  var i,j:integer;
  begin
    j:=length(p_joint^.descendants);
    if j > 0 then
    begin
      p_joint^.rotation[0]:=in_between.data[draw_counter];
      inc(draw_counter);

      p_joint^.rotation[1]:=in_between.data[draw_counter];
      inc(draw_counter);

      p_joint^.rotation[2]:=in_between.data[draw_counter];
      inc(draw_counter);
      for i:=0 to j-1 do
        load_rotations(p_joint^.descendants[i]);
    end;
  end;

begin
  whole:=round(f);
  alfa:=f-whole;
  // interpolation of the root positions
  x_pos:=(1-alfa)*animation.frames[whole].data[0] + alfa*animation.frames[whole+1].data[0];
  y_pos:=(1-alfa)*animation.frames[whole].data[1] + alfa*animation.frames[whole+1].data[1];
  z_pos:=(1-alfa)*animation.frames[whole].data[2] + alfa*animation.frames[whole+1].data[2];

  // creation of in-between frame
  in_between:=TFrame.Create;
  SetLength(in_between.data,(joints_count+1)*3);

  in_between.data[0]:=x_pos;
  in_between.data[1]:=y_pos;
  in_between.data[2]:=z_pos;
//zatial bez quaternionov
  for i:=3 to (joints_count+1)*3-1 do
  begin
    in_between.data[i]:=(1-alfa)*animation.frames[whole].data[i] + alfa*animation.frames[whole+1].data[i];
  end;

  if f=0 then y0:=y_pos; //we save the y value of the 1st frame

  draw_counter:=3;
  load_rotations(root);

//three nulls for initial rotations ensure that the offset
//executes allways before rotations at individual joint
  kresli(root^,x_pos,y_pos-y0,z_pos,0,0,0);
end;


procedure TSkeleton.Save(name: string);
var l_file:TFileStream;
    list:TStringList;
    format_string:TFormatSettings;
    gap,zyx_string,frame_string:string;
    i,j:integer;
    gap_count:byte;
    row:word;


  procedure save_joint(l_joint:TJoint;l_gap:string);
  var pom:byte;
      i:integer;
  begin

  if not l_joint.is_end then
  begin
    inc(row);
    list.Insert(row,l_gap+'JOINT '+l_joint.name);
    inc(row);
    list.Insert(row,l_gap+'{');
    gap_count:=gap_count+2;
    inc(row);
    list.Insert(row,l_gap+'  '+'OFFSET '+FloatToStr(l_joint.offset[0],format_string)+' '+FloatToStr(l_joint.offset[1],format_string)+' '+FloatToStr(l_joint.offset[2],format_string));
    inc(row);
    list.Insert(row,l_gap+'  '+zyx_string);
    pom:=length(l_joint.descendants);
      for i:=0 to pom-1 do
        save_joint(l_joint.descendants[i]^,l_gap+'  ');
    inc(row);
    list.Insert(row,l_gap+'}');

  end
  else
  begin
    inc(row);
    list.Insert(row,l_gap+'End Site');
    inc(row);
    list.Insert(row,l_gap+'{');
    gap_count:=gap_count+2;
    inc(row);
    list.Insert(row,l_gap+'  '+'OFFSET '+FloatToStr(l_joint.offset[0],format_string)+' '+FloatToStr(l_joint.offset[1],format_string)+' '+FloatToStr(l_joint.offset[2],format_string));
    inc(row);
    list.Insert(row,l_gap+'}');
  end;
  end;

begin
  frame_string:='';
  gap:='';
  gap_count:=0;
  row:=0;
  GetLocaleFormatSettings(0,format_string);
  format_string.DecimalSeparator:='.';

  if zyx then
    zyx_string:='CHANNELS 3 Zrotation Yrotation Xrotation'
  else
    zyx_string:='CHANNELS 3 Zrotation Xrotation Yrotation';

  list:=TStringList.Create;
  l_file:=TFileStream.Create(name,fmCreate);
  l_file.Free;
  l_file:=TFileStream.Create(name,fmOpenWrite);

  list.Insert(row,'HIERARCHY');

//ROOT
  inc(row);
  list.Insert(row,'ROOT '+root.name);
  inc(row);
  list.Insert(row,'{');

  gap_count:=2;
  for i:=1 to gap_count do
    gap:=gap+' ';

  inc(row);
  list.Insert(row,gap+'OFFSET '+FloatToStr(root.offset[0],format_string)+' '+FloatToStr(root.offset[1],format_string)+' '+FloatToStr(root.offset[2],format_string));
  inc(row);
  if zyx then
    list.Insert(row,gap+'CHANNELS 6 Xposition Yposition Zposition Zrotation Yrotation Xrotation')
  else
    list.Insert(row,gap+'CHANNELS 6 Xposition Yposition Zposition Zrotation Xrotation Yrotation');

  j:=length(root.descendants);
  for i:=0 to j-1 do
    save_joint(root.descendants[i]^,gap);
  inc(row);
  list.Insert(row,'}');

//MOTION
  inc(row);
  list.Insert(row,'MOTION');
  inc(row);
  list.Insert(row,'Frames: '+IntToStr(frames_count));
  inc(row);
  list.Insert(row,'Frame Time: '+FloatToStr(frame_time,format_string));

  for j:=0 to frames_count-1 do
  begin
    frame_string:='';
    inc(row);
    for i:=0 to (3+joints_count*3-1) do
      frame_string:=frame_string+FloatToStr(animation.frames[j].data[i],format_string)+' ';
    list.Insert(row,frame_string);
  end;

  list.SaveToStream(l_file);
  l_file.Free;
end;

{ TFrame }

constructor TFrame.Create();
begin
  SetLength(data,0);
end;

constructor TFrame.Create(frame1, frame2: TFrame; w: real);
var i:integer;
begin
  SetLength(data,0);
  SetLength(data,length(frame1.data));
  for i:={3}0 to length(frame1.data)-1 do
    data[i]:=(1-w)*frame1.data[i] + w*frame2.data[i];

end;

destructor TFrame.Destroy;
begin
// free data array?
  inherited;
end;

{ TAnimation }

constructor TAnimation.Create(n: string);
begin
  name:=n;
  Setlength(PCD,0);
  setlength(frames,0);
end;

destructor TAnimation.Destroy;
var i:word;
begin
  for i:=0 to high(frames) do
    frames[i].Destroy;
  inherited;
end;

begin
end.
